<?php
/**
 * 1. CMYK CONVERSION HELPER
 */
if (!function_exists('convertAndSaveCMYK')) {
    function convertAndSaveCMYK($inputPath, $outputPath) {
        if (!extension_loaded('imagick')) return false;
        
        $im = new Imagick($inputPath);
        
        // Quality Improvements
        $im->setImageResolution(300, 300); // High Resolution
        $im->setImageUnits(Imagick::RESOLUTION_PIXELSPERINCH);
        
        // Sharper Scaling and Colors
        $im->setImageCompressionQuality(100); // Max Quality
        $im->setSamplingFactors(['1:1', '1:1', '1:1']); // Chroma subsampling disable karein
        
        // Convert to CMYK profile correctly
        $im->transformImageColorspace(Imagick::COLORSPACE_CMYK);
        
        $im->setImageFormat('jpg');
        $im->writeImage($outputPath);
        $im->clear();
        $im->destroy();
        return true;
    }
}

/**
 * 2. TEXT HELPERS
 */
if (!function_exists('centerTextX')) {
    function centerTextX($bg, $size, $angle, $fontFile, $text) {
        $box = imagettfbbox($size, $angle, $fontFile, $text);
        $textWidth = $box[2] - $box[0];
        return (int) ((imagesx($bg) - $textWidth) / 2);
    }
}

if (!function_exists('wrapText')) {
    function wrapText($bg, $size, $angle, $fontFile, $text, $maxWidth) {
        $words = explode(" ", $text);
        $lines = []; $currentLine = "";
        foreach ($words as $word) {
            $testLine = $currentLine . ($currentLine ? " " : "") . $word;
            $box = imagettfbbox($size, $angle, $fontFile, $testLine);
            if (($box[2] - $box[0]) > $maxWidth) {
                $lines[] = $currentLine; $currentLine = $word;
            } else { $currentLine = $testLine; }
        }
        $lines[] = $currentLine;
        return $lines;
    }
}

/**
 * 3. GENERATE FRONT SIDE
 */
function generate_id_card_front($data, $file) {
    $baseDir = __DIR__;
    $bgPath = $baseDir . "/ID.jpg";
    
    // CMYK to RGB for editing in GD
    $im = new Imagick($bgPath);
    $im->transformImageColorspace(Imagick::COLORSPACE_SRGB);
    $bg = imagecreatefromstring($im->getImageBlob());
    $im->clear(); $im->destroy();

    $black = imagecolorallocate($bg, 0, 0, 0);
    $fontB = $baseDir . "/arialbd.ttf";
    $fontN = $baseDir . "/arial.ttf";
    $fontArialBlack = $baseDir . "/ariblk.ttf"; // Arial Black file ka path

    // --- Photo Placement (Shifted Upwards) ---
    if (isset($file['tmp_name']) && !empty($file['tmp_name'])) {
        $src = imagecreatefromstring(file_get_contents($file['tmp_name']));
        
        $pWidth = 255; 
        $pHeight = 285;
        $photo = imagescale($src, $pWidth, $pHeight);
        
        $bgW = imagesx($bg);
        $centerX = ($bgW - $pWidth) / 2;
        
        // Pehle ye 320 ya 300 tha, ise 285 karne se photo thodi upar chali jayegi
        $newY = 255; 
    
        imagecopy($bg, $photo, $centerX, $newY, 0, 0, $pWidth, $pHeight);
        
        // Solid Border (Exact thickness match)
        $borderThickness = 2; 
        for ($i = 0; $i < $borderThickness; $i++) {
            imagerectangle($bg, $centerX - $i, $newY - $i, $centerX + $pWidth + $i, $newY + $pHeight + $i, $black);
        }
        
        imagedestroy($src); 
        imagedestroy($photo);
    }

    // Role, Name, Agency
    // --- 1. Role (SUB STOCKIST) - Clean & Solid ---
    $roleText = strtoupper($data['role']);
    $roleFontSize = 42; 
    $fontArialBlack = $baseDir . "/Helvetica Rounded Bold.otf"; 
    
    $roleX = centerTextX($bg, $roleFontSize, 0, $fontArialBlack, $roleText);
    $roleY = 608; 
    
    // Single layer hi kaafi hai Arial Black ke liye (Extra sharp dikhega)
    imagettftext($bg, $roleFontSize, 0, $roleX, $roleY, $black, $fontArialBlack, $roleText);
    
    // Font path update (arialbd.ttf Bold use karne ke liye)
    $fontH = $baseDir . "/Helvetica Rounded Bold.otf"; 

    // --- 2. Name - Normal Spacing & Simple Logic ---
    $nameText = strtoupper($data['name']);
    $nameFontSize = 30; 
    
    // Normal centering logic (Loop ki zaroorat nahi hai)
    $nameX = centerTextX($bg, $nameFontSize, 0, $fontH, $nameText);
    $nameY = 665; 
    
    // Simple imagettftext use karein, isse alphabet spacing normal (default) ho jayegi
    imagettftext($bg, $nameFontSize, 0, $nameX, $nameY, $black, $fontH, $nameText);
    // --- 3. Agency - Exact Match ---
    $agencyText = strtoupper($data['agency']);
    $agencyFontSize = 26; // Image match: Name (32) se thoda chota
    $fontH = $baseDir . "/Helvetica Rounded Bold.otf"; // Helvetica Rounded Bold.otf Bold use karein
    
    // Normal centering logic (Alphabet spacing default)
    $agencyX = centerTextX($bg, $agencyFontSize, 0, $fontH, $agencyText);
    
    // Y position adjustment: 765 se ghata kar 715 kiya taaki gap sahi rahe
    $agencyY = 715; 
    
    // Simple single layer for sharp printing
    imagettftext($bg, $agencyFontSize, 0, $agencyX, $agencyY, $black, $fontH, $agencyText);

    // --- Details Block Start (Niche shift kiya gaya hai) ---
   // --- 1. Font Configuration (Har field ke liye alag font file) ---
    $f_AddrL = $baseDir . "/Helvetica Rounded Bold.otf";  $f_AddrV = $baseDir . "/Helvetica Rounded Bold.otf";
    $f_PhnL  = $baseDir . "/Helvetica Rounded Bold.otf";  $f_PhnV  = $baseDir . "/Helvetica Rounded Bold.otf";
    $f_DistL = $baseDir . "/Helvetica Rounded Bold.otf";  $f_DistV = $baseDir . "/Helvetica Rounded Bold.otf";
    $f_CidL  = $baseDir . "/Helvetica Rounded Bold.otf";  $f_CidV  = $baseDir . "/Helvetica Rounded Bold.otf";
    $f_AadL  = $baseDir . "/Helvetica Rounded Bold.otf";  $f_AadV  = $baseDir . "/Helvetica Rounded Bold.otf";
    $f_PanL  = $baseDir . "/Helvetica Rounded Bold.otf";  $f_PanV  = $baseDir . "/Helvetica Rounded Bold.otf";
    
    // --- 2. Shared Coordinates ---
    $lx = 65;   // Label X
    $cx = 245;  // Colon X
    $vx = 275;  // Value X
    $y  = 775;  // Start Y (Niche wala blue section)
    $maxWidth = 550;
    
    // --- 3. Manual Size Adjustment per Field ---
    // ADDRESS
    $s_AL = 21; $s_AV = 22; // Label Size, Value Size
    imagettftext($bg, $s_AL, 0, $lx, $y, $black, $f_AddrL, "ADDRESS");
    // Colon ko extra bold aur bada karne ke liye update
    imagettftext($bg, $s_AL + 4, 0, $cx, $y, $black, $baseDir . "/arialbd.ttf", ":");
    $addrLines = wrapText($bg, $s_AV, 0, $f_AddrV, strtoupper($data['address']), $maxWidth);
    foreach ($addrLines as $idx => $line) {
        imagettftext($bg, $s_AV, 0, $vx, $y, $black, $f_AddrV, trim($line));
        if ($idx < count($addrLines)-1) $y += 30; // Address lines gap
    }
    $y += 45; // Gap after address block
    
    // PHONE NO.
    $s_PL = 21; $s_PV = 24;
    imagettftext($bg, $s_PL, 0, $lx, $y, $black, $f_PhnL, "PHONE NO.");
    imagettftext($bg, $s_AL + 4, 0, $cx, $y, $black, $baseDir . "/arialbd.ttf", ":");
    imagettftext($bg, $s_PV, 0, $vx, $y, $black, $f_PhnV, strtoupper($data['phone']));
    $y += 42;
    
    // DISTRICT
    $s_DL = 21; $s_DV = 24;
    imagettftext($bg, $s_DL, 0, $lx, $y, $black, $f_DistL, "DISTRICT");
    imagettftext($bg, $s_AL + 4, 0, $cx, $y, $black, $baseDir . "/arialbd.ttf", ":");
    imagettftext($bg, $s_DV, 0, $vx, $y, $black, $f_DistV, strtoupper($data['district']));
    $y += 42;
    
    // CID NO.
    $s_CL = 21; $s_CV = 24;
    imagettftext($bg, $s_CL, 0, $lx, $y, $black, $f_CidL, "CID NO.");
    imagettftext($bg, $s_AL + 4, 0, $cx, $y, $black, $baseDir . "/arialbd.ttf", ":");
    imagettftext($bg, $s_CV, 0, $vx, $y, $black, $f_CidV, strtoupper($data['cid']));
    $y += 42;
    
    // AADHAR NO.
    $s_AadL = 21; $s_AadV = 24;
    imagettftext($bg, $s_AadL, 0, $lx, $y, $black, $f_AadL, "AADHAR NO.");
    imagettftext($bg, $s_AL + 4, 0, $cx, $y, $black, $baseDir . "/arialbd.ttf", ":");
    imagettftext($bg, $s_AadV, 0, $vx, $y, $black, $f_AadV, strtoupper($data['aadhaar']));
    $y += 42;
    
    // PAN
    $s_PanL = 21; $s_PanV = 24;
    imagettftext($bg, $s_PanL, 0, $lx, $y, $black, $f_PanL, "PAN");
    imagettftext($bg, $s_AL + 4, 0, $cx, $y, $black, $baseDir . "/arialbd.ttf", ":");
    imagettftext($bg, $s_PanV, 0, $vx, $y, $black, $f_PanV, strtoupper($data['pan']));

    // --- 1. Footer Font Configuration ---
    $f_FooterL = $baseDir . "/arialbd.ttf"; // Footer Labels (ISSUED BY, ISSUE DATE)
    $f_FooterV = $baseDir . "/arialbd.ttf"; // Footer Values (Tiger Associates, Date)
    
    // --- 2. Footer Size & Position ---
    $footerY = 1145; 
    $s_FL = 18; // Label Size
    $s_FV = 22; // Value Size
    
    // --- 3. ISSUED BY Section (Left Aligned) ---
    $issuedByLabel = "ISSUED BY : ";
    $issuedByValue = ($data['issued_by']);
    
    // Label print karein
    imagettftext($bg, $s_FL, 0, 50, $footerY, $black, $f_FooterL, $issuedByLabel);
    
    // Value ki position calculate karein (Label ke theek khatam hone ke baad)
    $labelBox = imagettfbbox($s_FL, 0, $f_FooterL, $issuedByLabel);
    $valueX_Left = 50 + ($labelBox[2] - $labelBox[0]) + 5; // 5px ka gap
    
    imagettftext($bg, $s_FV, 0, $valueX_Left, $footerY, $black, $f_FooterV, $issuedByValue);
    
    // --- 4. ISSUE DATE Section (Right Aligned) ---
    $dateLabel = "ISSUE DATE : ";
    $dateValue = $data['issue_date'];
    
    // Right side alignment ke liye fixed X use kiya hai
    $dateX_Start = 495; 
    imagettftext($bg, $s_FL, 0, $dateX_Start, $footerY, $black, $f_FooterL, $dateLabel);
    
    // Value ki position calculate karein
    $dateLabelBox = imagettfbbox($s_FL, 0, $f_FooterL, $dateLabel);
    $valueX_Right = $dateX_Start + ($dateLabelBox[2] - $dateLabelBox[0]) + 5;
    
    imagettftext($bg, $s_FV, 0, $valueX_Right, $footerY, $black, $f_FooterV, $dateValue);

    $temp = $baseDir . "/generated/temp_f.png";
    imagepng($bg, $temp);
    $final = "generated/card_" . time() . "_FRONT.jpg";
    convertAndSaveCMYK($temp, $baseDir . "/" . $final);
    unlink($temp);
    return $final;
}

/**
 * 4. GENERATE BACK SIDE (TOLL FREE AT BOTTOM)
 */
function generate_id_card_back($frontPath) {
    $baseDir = __DIR__;
    
    // Background Load
    $im = new Imagick($baseDir . "/ID.jpg");
    $im->transformImageColorspace(Imagick::COLORSPACE_SRGB);
    $bg = imagecreatefromstring($im->getImageBlob());
    $im->clear(); $im->destroy();

    $black = imagecolorallocate($bg, 0, 0, 0);
    $fontB = $baseDir . "/arialbd.ttf";
    $fontN = $baseDir . "/arial.ttf";
    $fontArialBlack = $baseDir . "/ariblk.ttf"; // Arial Black file ka path
    $bgW   = imagesx($bg);
    $bgH   = imagesy($bg);
    $leftMargin = 95;
    $maxWidth = $bgW - 180;

    // --- 1. QR Code ---
    $qrSize = 280;
    if (file_exists($baseDir . '/phpqrcode/qrlib.php')) {
        require_once $baseDir . '/phpqrcode/qrlib.php';
        $qrTemp = $baseDir . "/generated/qr_t_" . time() . ".png";
        QRcode::png("https://bibaba.xyz/card-generator/" . $frontPath, $qrTemp, QR_ECLEVEL_L, 6, 2);
        $qrSrc = imagecreatefrompng($qrTemp);
        $qrRescaled = imagescale($qrSrc, $qrSize, $qrSize);
        imagecopy($bg, $qrRescaled, (int)(($bgW - $qrSize) / 2), 230, 0, 0, $qrSize, $qrSize);
        imagedestroy($qrSrc); imagedestroy($qrRescaled);
        if (file_exists($qrTemp)) unlink($qrTemp);
    }

// --- 2. Distributor Details (Shifted Down & Left) ---
    $y = 570; // 520 se badhakar 570 kiya taaki poora block niche shift ho
    $leftMargin = 70; // 95 se ghatakar 70 kiya taaki left shift ho
    $maxWidth = $bgW - 140; // Margin ke hisaab se width adjust ki
    
    $text = "DISTRIBUTOR :"; 
    $fontSize = 25;
    
    // 1. Text print karein (Deep Black effect ke liye 0.5 offset)
    imagettftext($bg, $fontSize, 0, $leftMargin, $y, $black, $fontB, $text);
    imagettftext($bg, $fontSize, 0, $leftMargin + 0.5, $y, $black, $fontB, $text);
    
    // 2. Exact width nikaalein
    $box = imagettfbbox($fontSize, 0, $fontB, $text);
    $textWidth = $box[2] - $box[0];
    
    // 3. Thin Underline
    $underlineY = $y + 2; 
    imageline($bg, $leftMargin, $underlineY, $leftMargin + $textWidth, $underlineY, $black);
    
    $y += 35;

    // --- 2.1 Distributor Name (Arial Black - Compact) ---
    $distText = "WEST BENGAL LOTTERY STOCKIST SYNDICATE PVT. LTD";
    $fontSizeDist = 17; 
    $tracking = 0.3; 
    $fontArialBlack = $baseDir . "/ariblk.ttf"; 
    
    $tempX = $leftMargin;
    for ($i = 0; $i < strlen($distText); $i++) {
        $char = $distText[$i];
        imagettftext($bg, $fontSizeDist, 0, $tempX, $y, $black, $fontArialBlack, $char);
        $box = imagettfbbox($fontSizeDist, 0, $fontArialBlack, $char);
        $tempX += (($box[2] - $box[0]) + $tracking); 
    }
    
    $y += 40;

    // --- 2.2 GSTIN (Arial Black) ---
    $gstText = "GSTIN : 19AAACW5102G1ZK";
    $fontSizeGST = 26; 
    imagettftext($bg, $fontSizeGST, 0, $leftMargin, $y, $black, $fontArialBlack, $gstText);
    
    $y += 42;

    // --- 2.3 Distributor Address (Exact Image Match) ---
    $addressText = "14A, Prince Golam Mohammad Road, Kolkata-700026, West Bengal";
    $fontSizeAddr = 20; 
    
    // Image ke mutabiq spacing wrapText function mein manage karein
    $distAddr = wrapText($bg, $fontSizeAddr, 0, $fontN, $addressText, $maxWidth);
    
    imageantialias($bg, true);
    
    foreach ($distAddr as $line) {
        // MATCH LOGIC: 
        // Image mein font "Solid Black" hai par "Bold" nahi. 
        // 0.4 ya 0.5 ka offset use karein, 0.8 se zyada mota lag sakta hai.
        imagettftext($bg, $fontSizeAddr, 0, $leftMargin, $y, $black, $fontN, $line);
        imagettftext($bg, $fontSizeAddr, 0, $leftMargin + 0.4, $y, $black, $fontN, $line);
        
        // LINE SPACING: 
        // Image mein lines ke beech gap bahut kam hai. 26 ya 27 pixels perfect rahenge.
        $y += 27; 
    }

    // --- 3. Area Distributor (Bold Underline Match) ---
    $y += 30; 
    $areaHeading = "AREA DISTRIBUTOR :";
    $fontSizeHeading = 25;
    
    imageantialias($bg, true);
    
    // 1. Heading Text (Deep Black)
    imagettftext($bg, $fontSizeHeading, 0, $leftMargin, $y, $black, $fontB, $areaHeading);
    imagettftext($bg, $fontSizeHeading, 0, $leftMargin + 0.5, $y, $black, $fontB, $areaHeading);
    
    // 2. Bold Underline Logic (Image Match)
    $boxArea = imagettfbbox($fontSizeHeading, 0, $fontB, $areaHeading);
    $textWidth = $boxArea[2] - $boxArea[0];
    $underlineY = $y + 4; // Text se halka sa niche
    
    // Line ki thickness badhane ke liye loop use karein
    // Image ke hisaab se 2 ya 3 pixels thickness perfect hai
    $lineThickness = 2; 
    for ($i = 0; $i < $lineThickness; $i++) {
        imageline($bg, $leftMargin, $underlineY + $i, $leftMargin + $textWidth, $underlineY + $i, $black);
    }
    
    $y += 38;

    // --- 3.1 Agency Name (Arial Black) ---
    $agencyText = "TIGER ASSOCIATES";
    imagettftext($bg, 22, 0, $leftMargin, $y, $black, $fontArialBlack, $agencyText);
    
    $y += 32;

    // --- 3.2 Area Address (Exact Spacing & Density Match) ---
    $areaAddressText = "55A, Shyama Prasad Mukherjee Rd, Kolkata-700026, West Bengal";
    $fontSizeAreaAddr = 20; 
    
    // Text wrap karein
    $areaAddr = wrapText($bg, $fontSizeAreaAddr, 0, $fontN, $areaAddressText, $maxWidth);
    
    imageantialias($bg, true);
    
    foreach ($areaAddr as $line) {
        // 1. Density Match: 
        // Image mein text 'Bold' nahi hai, sirf 'Solid Black' hai. 
        // 0.4px ka offset perfect hai bina letters ko mote kiye.
        imagettftext($bg, $fontSizeAreaAddr, 0, $leftMargin, $y, $black, $fontN, $line);
        imagettftext($bg, $fontSizeAreaAddr, 0, $leftMargin + 0.4, $y, $black, $fontN, $line);
        
        // 2. Spacing Match: 
        // Image mein lines bilkul chipki hui hain. 
        // Ise 28 se ghatakar 26-27 karke dekhein.
        $y += 27; 
    }

    // --- 4. Disclaimer (Final Image Match) ---
    $y += 28; 
    $disclaimerText = "DISCLAIMER";
    $fontSizeDisc = 24;
    
    imageantialias($bg, true);
    
    // 1. Heading (Deep Black)
    imagettftext($bg, $fontSizeDisc, 0, $leftMargin, $y, $black, $fontB, $disclaimerText);
    imagettftext($bg, $fontSizeDisc, 0, $leftMargin + 0.5, $y, $black, $fontB, $disclaimerText);
    
    // 2. Bold Underline (Image Match)
    $boxD = imagettfbbox($fontSizeDisc, 0, $fontB, $disclaimerText);
    $textWidthD = $boxD[2] - $boxD[0];
    $underlineY = $y + 4; // Text se juda hua par solid
    
    // Underline thickness (2px for solid look as per image)
    for ($i = 0; $i < 2; $i++) {
        imageline($bg, $leftMargin, $underlineY + $i, $leftMargin + $textWidthD, $underlineY + $i, $black);
    }
    
    $y += 35; 
    
    // --- 3. Disclaimer Body Text (3 Lines Fit Match) ---
    $f_Disc       = $baseDir . "/arial.ttf"; // Clean look ke liye alag font variable
    $fontSizeBody = 17.5;                      // 17 se thoda chota kiya taaki 3 lines mein fit ho jaye
    $maxWidth     = 690;                     // Width ko thoda badhaya taaki text fail sake
    $dx           = 65;                      // Left alignment
    $y_disc       = 1050;                    // Starting Y position
    
    $disc = "This ID Card is Non-Transferable and it's loss must be reported immediately to Issuing Authority. This ID Card must be surrendered to issuing authority upon termination of bearer's status.";
    
    // Font variable ($f_Disc) ko separately wrapText mein dala
    $discLines = wrapText($bg, $fontSizeBody, 0, $f_Disc, $disc, $maxWidth);
    
    foreach ($discLines as $l) {
        if ($y > 1115) break; 
        
        // MATCH LOGIC: 
        // Image mein font regular hai par ink dense hai. 
        // 0.4px offset se ye 'Thin' nahi lagega aur sharp rahega.
        imagettftext($bg, $fontSizeBody, 0, $leftMargin, $y, $black, $fontN, $l);
        imagettftext($bg, $fontSizeBody, 0, $leftMargin + 0.4, $y, $black, $fontN, $l);
        
        // Spacing: Image mein lines kaafi compact hain
        $y += 26; 
    }

    // --- 5. Toll Free Number (Final Image Match) ---
    $tollText = "TOLL FREE NO. : +91 1800 103 6711";
    // Image mein ye kafi bold aur bada hai, 24-25 size perfect rahega
    $tollSize = 25; 
    $fontArialBlack = $baseDir . "/arialnarrow_bold.ttf"; 
    
    imageantialias($bg, true);
    
    // 1. Horizontal Center calculation
    $tollX = centerTextX($bg, $tollSize, 0, $fontArialBlack, $tollText);
    
    // 2. Vertical Position
    // Image mein blue wave ke thoda upar hai. 1130-1140 range perfect hai.
    $tollY = 1135; 
    
    // 3. Printing (Deep Black Logic)
    // Arial Black naturally thick hai, par 0.5px offset isko printer-ready solid black banayega
    imagettftext($bg, $tollSize, 0, $tollX, $tollY, $black, $fontArialBlack, $tollText);
    imagettftext($bg, $tollSize, 0, $tollX + 0.5, $tollY, $black, $fontArialBlack, $tollText);

    // Save
    $temp = $baseDir . "/generated/temp_b.png";
    imagepng($bg, $temp);
    $final = str_replace("_FRONT.jpg", "_BACK.jpg", $frontPath);
    convertAndSaveCMYK($temp, $baseDir . "/" . $final);
    imagedestroy($bg);
    if (file_exists($temp)) unlink($temp);
    
    return $final;
}

function generateCard($data, $file) {
    $f = generate_id_card_front($data, $file);
    $b = generate_id_card_back($f);
    return ['front' => $f, 'back' => $b];
}