<?php
require_once 'generate.php';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $res = generateCard($_POST, $_FILES['photo']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Card Preview</title>
    <style>
        body { background: #f0f2f5; font-family: sans-serif; text-align: center; padding: 20px; }
        .card-wrap { display: flex; justify-content: center; gap: 20px; flex-wrap: wrap; }
        .card { background: #fff; padding: 10px; border-radius: 8px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        img { width: 380px; height: auto; border: 1px solid #ddd; }
        .download-btn { display: inline-block; margin-top: 20px; padding: 12px 25px; background: #28a745; color: #fff; text-decoration: none; border-radius: 5px; font-weight: bold; }
    </style>
</head>
<body>
    <h2>ID Card Preview (CMYK JPG)</h2>
    <?php if (isset($res)): ?>
        <div class="card-wrap">
            <div class="card">
                <h3>FRONT</h3>
                <img src="<?php echo $res['front']; ?>?t=<?php echo time(); ?>">
            </div>
            <div class="card">
                <h3>BACK</h3>
                <img src="<?php echo $res['back']; ?>?t=<?php echo time(); ?>">
            </div>
        </div>
        <a href="<?php echo $res['front']; ?>" download class="download-btn">Download Front</a>
        <a href="<?php echo $res['back']; ?>" download class="download-btn">Download Back</a>
    <?php endif; ?>
</body>
</html>